/*
 * 作成日: 2008/08/05
 * 著作権: Copyright (c) 2005 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.dto;


import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.ext.s2jdbc.CodeGenerator;
import zigen.plugin.db.ext.s2jdbc.dto.rule.DefaultDtoMappingFactory;
import zigen.plugin.db.ext.s2jdbc.dto.rule.IDtoMappingFactory;
import zigen.plugin.db.ext.s2jdbc.util.PropertyNameUtil;

/**
 * S2JDBC EntityCreator.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/07/10 ZIGEN create.
 * 
 */
public class DtoGenerator extends CodeGenerator {
	
	String className;
	
	TableColumn[] columns;
	
	boolean underLineCut = true;
	
	String accessModifiers = "public"; // 初期値 public //$NON-NLS-1$
	
	IDtoMappingFactory mapping;
	
	public DtoGenerator(IDBConfig config, String className, TableColumn[] columns) {
		this.className = className;
		this.columns = columns;
		this.mapping = DefaultDtoMappingFactory.getFactory(config);
	}
	
	// プロパティ定義
	private void do_property() {
		for (int i = 0; i < columns.length; i++) {
			TableColumn col = (TableColumn) columns[i];
			println("\t/**"); //$NON-NLS-1$
			println("\t * " + col.getColumnName()); //$NON-NLS-1$
			println("\t */"); //$NON-NLS-1$
			

			// if (mapping.isLargeObject(col.getDataType())) {
			// println("\t@Lob");
			// }
			//
			String temporalType = mapping.getTemporalType(col.getDataType());
			if (temporalType != null) {
				println("\t@Temporal(" + temporalType + ")");
			}
			println("\t" + propertyString(accessModifiers, getJavaType(col), PropertyNameUtil.getProperty(col, underLineCut))); //$NON-NLS-1$
			println();
		}
	}
	
	private void do_import() {
		// println("import java.io.Serializable;"); //$NON-NLS-1$
		println("import javax.persistence.*;"); //$NON-NLS-1$
		// println("import java.util.Date;");
		println();
	}
	
	private void do_classBegin() {
		// println("public class " + getClassName() + " implements Serializable{"); //$NON-NLS-1$ //$NON-NLS-2$
		println("public class " + getClassName() + "{"); //$NON-NLS-1$ //$NON-NLS-2$
		println();
		
		// for Serializable
		// println("\tprivate static final long serialVersionUID = 1L;");
		// println();
	}
	
	private void do_classEnd() {
		println("}"); //$NON-NLS-1$
	}
	
	
	public void execute() {
		super.setGenerateInfo();
		do_import();
		super.setClassComment();
		do_classBegin();
		do_property();
		do_toString();
		do_classEnd();
	}
	
	public String getClassName() {
		
		// 以下は頭大文字＋Suffixを付ける処理
		// String str = queryName;
		// StringBuffer sb = new StringBuffer();
		// sb.append(str.substring(0, 1).toUpperCase());
		// sb.append(str.substring(1, str.length()).toLowerCase());
		// sb.append(prefix); // prefix(VO)
		// return sb.toString();
		
		return this.className;
	}
	
	private void do_toString() {
		String[] properties = new String[columns.length];
		for (int i = 0; i < columns.length; i++) {
			TableColumn col = (TableColumn) columns[i];
			properties[i] = PropertyNameUtil.getProperty(col, underLineCut);
		}
		println(toStringString(getClassName(), properties));
	}
	
	private String getJavaType(TableColumn tCol) {
		return mapping.getJavaType(tCol);
	}
	

}
